﻿using Percent___Qualification_work.Classes;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Percent___Qualification_work.userControls
{
    public partial class EditNoteControl : UserControl
    {
        public int noteID;
        public event EventHandler NoteUpdated;
        public EditNoteControl()
        {
            InitializeComponent();
        }

        public void InitializeEditNoteControl(int noteID)
        {
            this.noteID = noteID;
            LoadNoteDetails();
        }

        public void LoadNoteDetails()
        {
            DataTable noteTable = DatabaseConnection.Instance.GetNoteByID(noteID);
            DataRow note = noteTable.Rows[0];
            noteName.Text = note["name"].ToString();
            noteText.Text = note["text"].ToString();
        }

        private void saveNote_Click(object sender, EventArgs e)
        {
            string name = noteName.Text;
            string text = noteText.Text;

            if (!string.IsNullOrEmpty(name) && !string.IsNullOrEmpty(text))
            {
                DatabaseConnection.Instance.UpdateNote(noteID, name, text);
                MessageBox.Show("Plan updated successfully!");
                NoteUpdated?.Invoke(this, EventArgs.Empty);
                this.Visible = false;
            }
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            this.Visible = false;
        }
    }
}
